package com.instabug.library.networkinterception.delegate.validate

import com.instabug.library.networkinterception.config.IBGNetworkInterceptionConfigurationProvider
import com.instabug.library.networkinterception.util.lcIsMultiPart
import com.instabug.library.networkinterception.util.lcIsOctetStream
import com.instabug.library.networkinterception.util.lcIsProtobuf
import com.instabug.library.networkinterception.util.toLowerCaseKeys

class DefaultRequestBodyValidator(
    private val configurations: IBGNetworkInterceptionConfigurationProvider
) : NetworkLogBodyValidator {

    private val maxAllowedBytes: Long
        get() = configurations.v2MaxAllowedBodySizeBytes

    override fun invoke(headers: Map<String, String>, contentLength: Long): Pair<Boolean, String?> =
        validate(headers.toLowerCaseKeys(), contentLength)

    private fun validate(
        lowerCaseKeyHeaders: Map<String, String>,
        contentLength: Long
    ) = when {
        contentLength > maxAllowedBytes -> false to generateLargeBodyMessage(maxAllowedBytes)
        shouldSkipRequestBodyCapture() -> false to null
        lowerCaseKeyHeaders.lcIsProtobuf() -> false to PROTOBUF_REQUEST_BODY
        lowerCaseKeyHeaders.lcIsOctetStream() -> false to BINARY_RAW_DATA
        lowerCaseKeyHeaders.lcIsMultiPart() -> false to MULTIPART_BODY
        else -> true to null
    }
    private fun shouldSkipRequestBodyCapture() = !configurations.shouldCaptureNetworkBodyLogs
}
