package com.instabug.library.networkinterception.delegate.validate

private const val LARGE_BODY = "Body omitted due to its large size > %s Bytes"

const val MULTIPART_BODY = "multipart body was omitted"
const val PROTOBUF_REQUEST_BODY = "Request body of type protobuf"
const val PROTOBUF_RESPONSE_BODY = "Response body of type protobuf"
const val BINARY_RAW_DATA = "Binary Payload is not supported by Instabug"

fun generateLargeBodyMessage(maxSizeBytes: Long) =
    LARGE_BODY.replace("%s", "$maxSizeBytes")
