package com.instabug.library.networkinterception.delegate.validate

import com.instabug.library.networkinterception.delegate.Utf8CodePointEvaluator
import com.instabug.library.networkinterception.util.isPlainText
import com.instabug.library.sanitize.Validator

class ByteArrayUtf8PlainTextValidator(
    private val utf8CodePointEvaluator: Utf8CodePointEvaluator
) : Validator<ByteArray> {

    override fun isValid(item: ByteArray): Boolean {
        utf8CodePointEvaluator.reset()
        return utf8CodePointEvaluator.isPlainText(item)
    }
}
