package com.instabug.library.networkinterception.delegate.extract

import com.instabug.library.factory.ParameterizedFactory
import java.io.OutputStream

class LazyOutputStreamExtractor(
    private val streamWrapperFactory: ParameterizedFactory<OutputStream, OutputStreamWrapperFactoryParam>
) : NetworkBodyExtractor<OutputStream> {

    override fun extract(
        body: OutputStream,
        onBodyReady: (body: String?, length: Long?) -> Unit
    ): OutputStream = streamWrapperFactory.create(OutputStreamWrapperFactoryParam(body, onBodyReady))
}
