package com.instabug.library.networkinterception.delegate.extract

import com.instabug.library.factory.ParameterizedFactory
import java.io.InputStream

class LazyInputStreamExtractor(
    private val streamWrapperFactory: ParameterizedFactory<InputStream, InputStreamWrapperFactoryParam>
) : NetworkBodyExtractor<InputStream> {
    override fun extract(
        body: InputStream,
        onBodyReady: (body: String?, length: Long?) -> Unit
    ): InputStream = streamWrapperFactory.create(InputStreamWrapperFactoryParam(body, onBodyReady))
}
