package com.instabug.library.networkinterception.delegate

import com.instabug.library.networkinterception.model.NetworkLogModel

/**
 * Delegate for common interception logic
 */
interface NetworkInterceptorDelegate<REQUEST, RESPONSE> {

    /**
     * Extracts GraphQL query from headers
     */
    fun getGraphQLQuery(requestHeaders: Map<String, String>): String?

    /**
     * Invalidate request headers the are passed through the network with the request by injecting
     * or removing headers to support different sub-features
     * with a [NetworkLogModel.Builder] to retain state and apply side effect logic to
     */
    fun invalidateRequestHeaders(
        requestHeaders: MutableMap<String, String>?,
        networkLogBuilder: NetworkLogModel.Builder
    ): MutableMap<String, String>?

    /**
     * Consume Request body if it's allowed
     */
    fun consumeRequestBody(
        requestHeaders: Map<String, String>,
        contentLength: Long,
        bodyFactory: () -> REQUEST,
        onBodyReady: (body: String?, length: Long?) -> Unit
    ): REQUEST?

    /**
     * Consume Response body if it's allowed
     */
    fun consumeResponseBody(
        responseHeaders: Map<String, String>,
        contentLength: Long,
        bodyFactory: () -> RESPONSE,
        onBodyReady: (body: String?, length: Long?) -> Unit
    ): RESPONSE?
}
