package com.instabug.library.networkinterception.config

interface IBGNetworkInterceptionConfigurationProvider {

    /**
     * Sets W3C external trace id feature availability percentage
     *
     * @param percentage set's the feature availability percentage
     */
    fun setW3CNetworkExternalTraceIdFeatureAvailabilityPercentage(percentage: Double)

    /**
     * Gets W3C external trace id feature enablement state.
     *
     * @return true if enabled false otherwise
     */
    fun isW3CNetworkExternalTraceIdEnabled(): Boolean

    /**
     * Sets V2 interception feature BE availability percentage
     *
     * @param percentage set's the feature availability percentage
     */
    fun setV2InterceptionFeatureAvailabilityPercentage(percentage: Double)

    /**
     * Gets V2 interception feature enablement state
     *
     * @return true if enabled, false otherwise
     */
    fun isV2InterceptionFeatureAvailable(): Boolean

    /**
     * generated W3C external trace id attaching feature BE state
     */
    var isAttachingGeneratedW3CExternalTraceIdFeatureAvailable: Boolean

    /**
     * returns generated W3C external trace id attaching enablement state.
     */
    val isAttachingGeneratedW3CExternalTraceIdEnabled: Boolean

    /**
     * captured W3C external trace id attaching feature BE state.
     */
    var isAttachingCapturedW3CExternalTraceIdFeatureAvailable: Boolean

    /**
     * returns captured W3C external trace id attaching enablement state.
     */
    val isAttachingCapturedW3CExternalTraceIdEnabled: Boolean

    var isNetworkLogBodyEnabledByBE: Boolean
    var isNetworkLogBodyEnabledBySDK: Boolean
    val shouldCaptureNetworkBodyLogs: Boolean

    /**
     * Sets network auto masking feature availability percentage
     *
     * @param percentage set's the feature availability percentage
     */
    fun setAutoMaskingFeatureAvailabilityPercentage(percentage: Double)

    /**
     * Gets Auto masking feature availability state.
     *
     * @return true if enabled false otherwise
     */
    fun isAutoMaskingAvailable(): Boolean

    /**
     * returns network auto masking SDK enablement state.
     */
    var isAutoMaskingSDKEnabled: Boolean

    /**
     * returns network auto masking feature enablement state.
     */
    val isAutoMaskingEnabled: Boolean

    /**
     * returns the header keys that will be masked provided by BE.
     */
    var autoMaskingBEHeaderKeys: Set<String>

    /**
     * returns the query keys that will be masked provided by BE.
     */
    var autoMaskingBEQueryKeys: Set<String>

    /**
     * Returns NetworkInterception state across all versions, taking into consideration
     * parent states e.g. Instabug enabled state
     */
    val networkInterceptionEnabled: Boolean

    /**
     * Gets V2 interception feature enablement state taking in consideration
     * parent states e.g. [networkInterceptionEnabled]
     *
     * @return false if feature is BE disabled or Instabug is disabled, true otherwise
     */
    val networkInterceptionV2Enabled: Boolean

    /**
     * Max allowed body size to be collected in bytes
     */
    var v2MaxAllowedBodySizeBytes: Long

    /**
     * StateFlag containing the combination of all possible states for OkHttp interceptor.
     * State is combination of the states in [V2InterceptorFlags]
     */
    var v2OkHttpInterceptorBEState: Int

    /**
     * StateFlag containing the combination of all possible states for UrlConnection interceptor.
     * State is combination of the states in [V2InterceptorFlags]
     */
    var v2UrlConnectionInterceptorBEState: Int

    /**
     * StateFlag containing the combination of all possible states for GRPC interceptor.
     * State is combination of the states in [V2InterceptorFlags]
     */
    var v2GrpcInterceptorBEState: Int

    /**
     * GraphQl feature availability BE state
     */
    var v2GqlFeatureAvailable: Boolean

    /**
     * Manual sanitization feature availability BE state
     */
    var v2ManualSanitizationAvailable: Boolean

    /**
     * Manual sanitization feature enablement state
     * will be false when [networkInterceptionV2Enabled] is false
     */
    val v2ManualSanitizationEnabled: Boolean

    /**
     * Instabug sanitization query parameters
     */
    var v2InstabugSanitizationQueryParams: Set<String>

    /**
     * Validates if a V2 interceptor should be enabled or not, given it's state flag Int(based on its
     * state flag and master flags)
     */
    fun Int.isV2InterceptorEnabled(): Boolean

    /**
     * Validates if a V1 interceptor should be enabled or not, given it's state flag Int(based on its
     * state flag and master flags)
     */
    fun Int.isV1InterceptorEnabled(): Boolean

    fun reset()

    /**
     * Reset all NetworkInterception configurations to their default values
     */
    fun resetAutoMasking()

    /**
     * Reset all V2 NetworkInterception configurations to their default values
     */
    fun resetV2InterceptionFlags()

    /**
     * Reset all V2 interception Sanitization flags to their default values
     */
    fun resetV2SanitizationFlags()
}
