package com.instabug.library.networkinterception.config

//region storage keys
const val KEY_W3C_EXTERNAL_TRACE_ID_AVAILABLE = "W3C_EXTERNAL_TRACE_ID_AVAILABLE"
const val KEY_GENERATED_W3C_ATTACHING_AVAILABLE = "GENERATED_W3C_ATTACHING_AVAILABLE"
const val KEY_CAPTURED_W3C_ATTACHING_AVAILABLE = "CAPTURED_W3C_ATTACHING_AVAILABLE"
const val KEY_V2_INTERCEPTION_AVAILABLE = "V2_INTERCEPTION_AVAILABLE"
const val KEY_V2_MAX_BODY_SIZE = "V2_MAX_BODY_SIZE"
const val KEY_V2_OK_HTTP_STATE = "V2_OK_HTTP_STATE"
const val KEY_V2_URL_CONNECTION_STATE = "V2_URL_CONNECTION_STATE"
const val KEY_V2_GRPC_STATE = "V2_GRPC_STATE"
const val KEY_V2_GQL_FEATURE_AVAILABLE = "V2_GQL_FEATURE_AVAILABLE"
const val KEY_V2_MANUAL_SANITIZATION_AVAILABLE = "V2_MANUAL_SANITIZATION_AVAILABLE"
const val KEY_V2_INSTABUG_SANITIZATION_QUERY_PARAMS = "V2_INSTABUG_SANITIZATION_QUERY_PARAMS"
//endregion

//region default values
const val DEFAULT_W3C_EXTERNAL_TRACE_ID_AVAILABLE = false
const val DEFAULT_W3C_EXTERNAL_TRACE_ID_PERCENTAGE = 0.0
const val DEFAULT_GENERATED_W3C_ATTACHING_AVAILABLE = false
const val DEFAULT_CAPTURED_W3C_ATTACHING_AVAILABLE = false
const val DEFAULT_V2_INTERCEPTION_AVAILABLE = true
const val DEFAULT_V2_INTERCEPTION_PERCENTAGE = 1.0
const val DEFAULT_V2_MAX_BODY_SIZE = 10240L
const val DEFAULT_V2_INTERCEPTOR_STATE = V2InterceptorFlags.ENABLED or
    V2InterceptorFlags.REQUEST_BODY_COLLECTION_ENABLED or
    V2InterceptorFlags.RESPONSE_BODY_COLLECTION_ENABLED
const val DEFAULT_V2_INTERCEPTOR_AVAILABLE = true
const val DEFAULT_V2_REQUEST_BODY_INTERCEPTION_AVAILABLE = true
const val DEFAULT_V2_RESPONSE_BODY_INTERCEPTION_AVAILABLE = true
const val DEFAULT_V2_GQL_FEATURE_AVAILABLE = false
const val DEFAULT_V2_MANUAL_SANITIZATION_AVAILABLE = true
val DEFAULT_V2_INSTABUG_SANITIZATION_QUERY_PARAMS: Set<String> = setOf(
    "application_token",
    "uuid"
)
const val DEFAULT_CAPTURE_NETWORK_BODY_LOG_BE = true
const val DEFAULT_CAPTURE_NETWORK_BODY_LOG_SDK = true
// endregion

//region BE config keys
const val KEY_BE_NETWORK_CONFIG = "network_config"
const val KEY_BE_W3C_EXTERNAL_TRACE_ID_AVAILABLE = "w3c_external_trace_id_enabled"
const val KEY_BE_ATTACHING_GENERATE_W3C_TRACE_ID_AVAILABLE = "w3c_generated_header"
const val KEY_BE_ATTACHING_CAPTURED_W3C_TRACE_ID_AVAILABLE = "w3c_caught_header"
const val KEY_BE_V2_INTERCEPTION_CONFIG = "an_network_v2"
const val KEY_BE_ENABLED = "enabled"
const val KEY_BE_MAX_BODY_SIZE = "network_log_char_limit"
const val KEY_BE_OK_HTTP_CONFIG = "okhttp"
const val KEY_BE_URL_CONNECTION_CONFIG = "urlconnection"
const val KEY_BE_GRPC_CONFIG = "grpc"
const val KEY_BE_REQUEST_BODY_COLLECTION = "req_body_cl"
const val KEY_BE_RESPONSE_BODY_COLLECTION = "res_body_cl"
const val KEY_BE_GQL_ENABLED = "gql_enabled"
const val KEY_BE_SANITIZATION_CONFIG = "sanitization"
const val KEY_BE_MANUAL_SANITIZATION_ENABLED = "man_enabled"
const val KEY_BE_INSTABUG_SANITIZATION_QUERY_PARAMS = "ibg_query_keys"
const val KEY_BE_CAPTURE_NETWORK_BODY_LOGS = "log_body"
//endregion

// Automasking

//region storage keys
const val KEY_AUTO_MASKING_AVAILABLE = "AUTOMASKING_AVAILABLE"
const val KEY_AUTO_MASKING_HEADER_KEYS = "AUTOMASKING_HEADER_KEYS"
const val KEY_AUTO_MASKING_QUERY_KEYS = "AUTOMASKING_QUERY_KEYS"
//endregion

//region default values
const val DEFAULT_AUTO_MASKING_BE_ENABLED = false
const val DEFAULT_AUTO_MASKING_SDK_ENABLED = true
const val DEFAULT_AUTO_MASKING_PERCENTAGE = 0.0
val DEFAULT_SDK_AUTO_MASKING_HEADER_KEYS = emptySet<String>()
val DEFAULT_SDK_AUTO_MASKING_QUERY_KEYS = emptySet<String>()
val DEFAULT_SDK_AUTO_MASKING_KEYS: Set<String>
    get() =
        setOf(
            "Authorization",
            "authorization_token",
            "auth_token",
            "auth",
            "access_token",
            "token",
            "oauth_token",
            "bearer_token",
            "refresh_token",
            "jwt_token",
            "jwt",
            "Username",
            "password",
            "pwd",
            "api_key",
            "apikey",
            "secret",
            "client_secret",
            "app_secret",
            "consumer_secret",
        )
// endregion

//region BE config keys
const val KEY_BE_AUTO_MASKING = "sdk_automasking"
const val KEY_BE_AUTO_MASKING_AVAILABLE = "enabled"
const val KEY_BE_AUTO_MASKING_HEADER_KEYS = "header_additions"
const val KEY_BE_AUTO_MASKING_QUERY_KEYS = "query_additions"
//endregion

// Error messages
const val AUTO_MASKING_ENABLED_BE_FLAG_DISABLED =
    "Network Auto masking wasn't enabled as the feature seems to be disabled for your Instabug company account. Please contact support for more information."
