package com.instabug.library.networkinterception

import com.instabug.library.internal.servicelocator.Provider
import com.instabug.library.networkinterception.config.IBGNetworkInterceptionConfigurationProvider
import com.instabug.library.networkinterception.delegate.NetworkInterceptorDelegate
import com.instabug.library.networkinterception.dispatch.NetworkLogDispatcher
import com.instabug.library.networkinterception.dispatch.NetworkLogReceiverRegistry
import java.io.InputStream

object NetworkInterceptionExternalServiceLocator {

    @JvmStatic
    val configurationProvider: IBGNetworkInterceptionConfigurationProvider
        get() = NetworkInterceptionServiceLocator.configurationProvider

    @JvmStatic
    val networkLogDispatcher: NetworkLogDispatcher
        get() = NetworkInterceptionServiceLocator.networkLogDispatcher

    @JvmStatic
    val networkLogReceiverRegistry: NetworkLogReceiverRegistry
        get() = NetworkInterceptionServiceLocator.networkLogReceiverRegistry

    @JvmStatic
    val networkLogProcessor: NetworkLogProcessor
        get() = NetworkInterceptionServiceLocator.processor

    @JvmStatic
    val okHttpDelegateProvider: Provider<NetworkInterceptorDelegate<InputStream, InputStream>?>
        get() = NetworkInterceptionServiceLocator.okHttpInterceptorDelegateProvider
}
