package com.instabug.library.model

import java.util.concurrent.TimeUnit

open class TimeCapture {
    val timeNano: Long
    val timeStampMs: Long

    init {
        timeNano = System.nanoTime()
        timeStampMs = System.currentTimeMillis()
    }

    open val timeMus
        get() = TimeUnit.NANOSECONDS.toMicros(timeNano)
    open val timeStampMus
        get() = TimeUnit.MILLISECONDS.toMicros(timeStampMs)

    fun getDurationMsStartingFrom(other: TimeCapture) =
        TimeUnit.NANOSECONDS.toMillis(getDurationNanoFrom(other))

    fun getDurationMusStartingFrom(other: TimeCapture) =
        TimeUnit.NANOSECONDS.toMicros(getDurationNanoFrom(other))

    fun getDurationNanoFrom(other: TimeCapture) = timeNano - other.timeNano
}
