package com.instabug.library.model;

import com.instabug.library.util.InstabugDateFormatter;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public class LogData {
    private static final String DATE_FORMAT = "HH:mm:ss.SSS";

    @Nullable
    private String tag;
    @Nullable
    private String message;
    private long timestamp;
    @Nullable
    private String currentThreadName;


    private LogData(@Nullable String tag, @Nullable String message, long timestamp, @Nullable String currentThreadName) {
        this.tag = tag;
        this.message = message;
        this.timestamp = timestamp;
        this.currentThreadName = currentThreadName;
    }

    @Nullable
    public String getMessage() {
        return message;
    }

    @Nullable
    public String getCurrentThreadName() {
        return currentThreadName;
    }

    public long getTimestamp() {
        return timestamp;
    }

    @Nullable
    public String getTag() {
        return tag;
    }

    public static class Builder {
        @Nullable
        private String tag;
        @Nullable
        private String message;
        private long timestamp;
        @Nullable
        private String currentThreadName;

        public Builder setTag(String tag) {
            this.tag = tag;
            return this;
        }

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder setCurrentThreadName(String currentThreadName) {
            this.currentThreadName = currentThreadName;
            return this;
        }

        public Builder setTimestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public LogData build() {
            return new LogData(tag, message, timestamp, currentThreadName);
        }
    }

    @NonNull
    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();

        String date = InstabugDateFormatter.convertUnixTimeToFormattedDate(timestamp,
                DATE_FORMAT);
        stringBuilder
                .append(date)
                .append(" ")
                .append(currentThreadName)
                .append("  ")
                .append(tag)
                .append("  ")
                .append(message)
                .append("\n");
        return stringBuilder.toString();
    }
}
