package com.instabug.library.model;

import android.annotation.SuppressLint;

import androidx.annotation.Nullable;

import com.instabug.library.internal.storage.cache.Cacheable;

import org.json.JSONException;
import org.json.JSONObject;

/**
 Created by Barakat on 28/01/2020
 */
public class FeaturesCache implements Cacheable {

    private static final int TTL_DECOMMISSIONING_VALUE = -1;

    public static final String TTL = "ttl";
    public static final String IS_ACTIVE = "is_active";
    public static final String SDK_VERSION = "sdk_version";
    public static final String HASH = "hash";

    private long ttl;
    private boolean isActive;
    private String sdkVersion;
    @Nullable
    private String hash;

    public FeaturesCache(long ttl, boolean isActive, String sdkVersion, @Nullable String hash) {
        this.ttl = ttl;
        this.isActive = isActive;
        this.sdkVersion = sdkVersion;
        this.hash = hash;
    }

    @SuppressLint("ERADICATE_FIELD_NOT_INITIALIZED")
    public FeaturesCache() {
    }

    public long getTtl() {
        return ttl;
    }

    public void setTtl(long ttl) {
        this.ttl = ttl;
    }

    public boolean isActive() {
        return isActive;
    }

    public void setActive(boolean active) {
        isActive = active;
    }

    public String getSdkVersion() {
        return sdkVersion;
    }

    public void setSdkVersion(String sdkVersion) {
        this.sdkVersion = sdkVersion;
    }

    @Nullable
    public String getHash() {
        return hash;
    }

    public void setHash(@Nullable String hash) {
        this.hash = hash;
    }

    /***
     * @return true if TTL == -1 and SDK isActive == false or false otherwise.
     */
    public boolean isSdkDecommissioned() {
        return getTtl() == TTL_DECOMMISSIONING_VALUE && !isActive();
    }

    @Override
    public String toJson() throws JSONException {
        JSONObject jsonObject = new JSONObject();

        jsonObject.put(TTL, getTtl());
        jsonObject.put(IS_ACTIVE, isActive());
        jsonObject.put(SDK_VERSION, getSdkVersion());
        String hash = getHash();
        if (hash != null) {
            jsonObject.put(HASH, hash);
        }

        return jsonObject.toString();
    }

    @Override
    public void fromJson(@Nullable String modelAsJson) throws JSONException {
        if (modelAsJson != null) {
            JSONObject jsonObject = new JSONObject(modelAsJson);
            this.setTtl(jsonObject.optLong(TTL, 0));
            this.setActive(jsonObject.optBoolean(IS_ACTIVE, true));
            this.setSdkVersion(jsonObject.optString(SDK_VERSION, ""));
            this.setHash(jsonObject.optString(HASH, ""));
        } else {
            this.setTtl(0);
            this.setActive(true);
            this.setSdkVersion("");
            this.setHash("");
        }
    }
}
