package com.instabug.library.internal.storage.cache.dbv2.migration

import android.database.sqlite.SQLiteDatabase
import com.instabug.library.internal.storage.cache.dbv2.IBGDbContract
import com.instabug.library.internal.storage.cache.dbv2.IBGEncryptedDbVersions

class DBMigrationV14(override val db: SQLiteDatabase) : BaseDBMigrationImpl(db) {
    override val previous: BaseDbMigration? by lazy { DBMigrationV13(db) }
    override val version: Int
        get() = IBGEncryptedDbVersions.DB_V14

    override fun execute() =
        runLogic {
            db.execSQL(
                "ALTER TABLE ${IBGDbContract.BugEntry.TABLE_NAME} ADD COLUMN ${IBGDbContract.BugEntry.COLUMN_CONNECTION_ERROR}"
                        + "${IBGDbContract.TEXT_TYPE} DEFAULT NULL"
            )
        }
}