package com.instabug.library.internal.storage.cache.dbv2.migration

import android.database.sqlite.SQLiteDatabase
import com.instabug.library.Constants
import com.instabug.library.diagnostics.diagnostics_db.migration.DiagnosticsDBMigrationV2
import com.instabug.library.util.InstabugSDKLogger

private const val MIGRATION_ERROR_MESSAGE = "Error while migrating to DB version: %d}"

abstract class BaseDBMigrationImpl(open val db: SQLiteDatabase) : BaseDbMigration {

    protected abstract val previous: BaseDbMigration?
    protected abstract val version: Int

    final override fun migrate(oldDBVersion: Int) {
        if (!canMigrate(oldDBVersion)) return
        previous?.migrate(oldDBVersion)
        execute()
    }

    abstract fun execute()

    private fun canMigrate(oldDbVersion: Int): Boolean = version > oldDbVersion

    protected fun runLogic(logic: () -> Unit) = runCatching(logic).getOrElse { throwable ->
        MIGRATION_ERROR_MESSAGE.format(version).let { message ->
            InstabugSDKLogger.e(Constants.LOG_TAG, message, throwable)
        }
        throw throwable
    }
}