package com.instabug.library.internal.layer;

import android.graphics.Bitmap;

import androidx.annotation.Size;

/**
 * Represents base of any custom views that should be capture-able using Instabug screenshot processor (CustomGoogleMaps, CustomDialogs, etc...)
 *
 * @author mSobhy
 */
public interface CapturableView {

    /**
     * Processes current view to return a {@link Bitmap} representation of it to be added to screenshot being processed
     *
     * @param snapshotPreparationCallback callback of current view screenshot process
     */
    void snapshot(SnapshotPreparationCallback snapshotPreparationCallback);

    /**
     * @return if this view is currently visible or not. if not visible will not be added to screenshot
     */
    boolean isVisible();

    /**
     * Computes the coordinates of this view on the screen. The argument must be an array of two integers.
     * After the method returns, the array contains the x and y location in that order.
     *
     * @param location an array of two integers in which to hold the coordinates
     */
    void getLocationOnScreen(@Size(2) int[] location);

    /**
     * A callback to provide the {@link Bitmap} representing a screenshot of a {@link CapturableView}
     */
    interface SnapshotPreparationCallback {
        /**
         * Should be called when a {@link Bitmap} representing this views is ready
         *
         * @param bitmap representing current {@link CapturableView}
         */
        void onSnapshotReady(Bitmap bitmap);

        /**
         * Should be called when this view wasn't able to provide a valid screenshot to be ignored from the screenshot processing <b>This is optional and doesn't have to occur</b>
         */
        void onSnapshotFailed();
    }
}