package com.instabug.library.internal.dataretention.files;

import com.instabug.library.internal.dataretention.core.Contract;
import com.instabug.library.internal.dataretention.core.DisposalPolicy;

import java.util.Arrays;
import java.util.Collection;

import androidx.annotation.NonNull;

public abstract class FileDisposalPolicy extends DisposalPolicy<FileRecord> {

    @NonNull
    @Override
    public abstract FileScope scope();

    @NonNull
    @Override
    public abstract Collection<FileRule> exceptionRules();

    public static class Factory {

        public FileDisposalPolicy create(@NonNull final String directoryPath,
                                         @NonNull final Contract contract,
                                         @NonNull final FileRule... exceptionRules) {
            return new FileDisposalPolicy() {

                @NonNull
                @Override
                public FileScope scope() {
                    return new FileScope.Factory().create(directoryPath);
                }

                @NonNull
                @Override
                public Collection<FileRule> exceptionRules() {
                    return Arrays.asList(exceptionRules);
                }

                @NonNull
                @Override
                public Contract retentionContract() {
                    return contract;
                }
            };
        }
    }
}
