package com.instabug.library.internal.dataretention.files;

import androidx.annotation.NonNull;

import com.instabug.library.internal.dataretention.core.Disposable;
import com.instabug.library.util.FileUtils;

import java.io.File;

public class FileDisposable implements Disposable {

    private final FileRecord record;

    public FileDisposable(@NonNull FileRecord record) {
        this.record = record;
    }

    @Override
    public void dispose() {
        File file = record.get();
        FileUtils.deleteDirectory(file);
    }
}
