package com.instabug.library.internal.dataretention.core;

import com.instabug.library.InstabugState;
import com.instabug.library.InstabugStateProvider;
import com.instabug.library.internal.resolver.LoggingSettingResolver;
import com.instabug.library.model.LoggingSettings;

import java.util.concurrent.TimeUnit;

import static com.instabug.library.model.LoggingSettings.DEFAULT_RETENTION_DAY;
import static com.instabug.library.model.LoggingSettings.DEFAULT_SIZE_LIMIT;
import static com.instabug.library.model.LoggingSettings.LogLevels;

public enum Contract {

    LOGS {
        @Override
        public long maxRetentionPeriodMillis() {
            LoggingSettings settings = LoggingSettingResolver.getInstance().getLoggingSettings();
            int retentionDays = settings == null ? DEFAULT_RETENTION_DAY : settings.getRetentionDay();
            return TimeUnit.DAYS.toMillis(retentionDays);
        }

        /**
         * @return max size limit in bytes
         */
        @Override
        public long maxRetentionSize() {
            LoggingSettings settings = LoggingSettingResolver.getInstance().getLoggingSettings();
            return settings == null ? DEFAULT_SIZE_LIMIT : settings.getSizeLimit();
        }

        @Override
        public boolean shouldPurge() {
            LoggingSettings settings = LoggingSettingResolver.getInstance().getLoggingSettings();
            boolean levelRule =  settings != null && settings.getLevel() == LogLevels.NO_LOGS;
            boolean sdkDisabledRule = InstabugStateProvider.getInstance().getState() == InstabugState.DISABLED && (settings != null && !settings.isKeepOnSdkDisabled());
            boolean shouldClearLogs = settings != null && settings.isShouldClearDiskLogs();
            return levelRule || sdkDisabledRule || shouldClearLogs;
        }
    };

    public static final long VALUE_UNDEFINED = -1;

    /**
     * Specifies how long data are to be retained.
     *
     * @return time in millis
     */
    public long maxRetentionPeriodMillis() {
        return VALUE_UNDEFINED;
    }

    /**
     * Specifies the max size of data
     *
     * @return number of database records, disk size, etc...
     */
    public long maxRetentionSize() {
        return VALUE_UNDEFINED;
    }

    /**
     * Specifies if data should be purged or not
     *
     * @return true if should purge, false otherwise
     */
    public boolean shouldPurge() {
        return false;
    }
}
