package com.instabug.library.internal.crossplatform

import com.instabug.library.internal.servicelocator.CoreServiceLocator
import com.instabug.library.screenshot.ScreenshotCaptor

object InternalCore {
    fun _isFeatureEnabled(@CoreFeature feature: Int, callback: FeatureStateCallback) =
        CPConfigurationsProvider.isFeatureEnabled(feature, callback)

    fun _isFeatureEnabled(@CoreFeature feature: Int) =
        CPConfigurationsProvider.isFeatureEnabled(feature)

    fun _setFeaturesStateListener(listener: FeaturesStateListener?) {
        CPConfigurationsProvider.setFeaturesStateListener(listener)
    }

    @SuppressWarnings("kotlin:S100")
    fun _setScreenshotCaptor(captor: ScreenshotCaptor) {
        CoreServiceLocator.screenshotCaptor = captor
    }

    fun _setOnFeaturesUpdatedListener(listener: OnFeaturesUpdatedListener?) {
        CoreServiceLocator.onFeaturesUpdatedHandler.onFeatureUpdatedListener = listener
    }

    val _networkLogCharLimit: Int get() = CPConfigurationsProvider.networkLogCharLimit
}
