package com.instabug.library.encryption

import android.annotation.SuppressLint
import android.os.Build
import androidx.annotation.VisibleForTesting
import com.instabug.library.BuildFieldsProvider
import java.security.Key

object KeyManager {

    @VisibleForTesting
    var encryptionkey: Key? = null

    @SuppressLint("NewApi")
    @JvmStatic
    fun getKey(): Key? {
        if (encryptionkey == null) {
            if (BuildFieldsProvider.provideBuildVersion() < Build.VERSION_CODES.JELLY_BEAN_MR2) {
                encryptionkey = StaticKeyProvider.getStaticKey()
            } else if (BuildFieldsProvider.provideBuildVersion() >= Build.VERSION_CODES.JELLY_BEAN_MR2 && Build.VERSION.SDK_INT < Build.VERSION_CODES.M) {
                encryptionkey = Post18KeyGenerator.getKeyPostApi18() ?: StaticKeyProvider.getStaticKey()
            } else if (BuildFieldsProvider.provideBuildVersion() >= Build.VERSION_CODES.M) {
                encryptionkey = Post22KeyGenerator.getKeyPostApi22() ?: StaticKeyProvider.getStaticKey()
            }
        }

        return encryptionkey
    }

}