package com.instabug.library.diagnostics.nonfatals.cache;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.instabug.library.diagnostics.nonfatals.model.NonFatal;

import java.util.List;

/**
 * Created by Shannan on 31/08/2021.
 */
public interface NonFatalsDBHelper {

    long NOT_FOUND = -1;

    /**
     * Saves NonFatal to non_fatal table
     *
     * @param nonFatal instance to be saved
     * @return true if saved, false otherwise
     */
    long insertNonFatal(@NonNull NonFatal nonFatal);

    /**
     * trim saved nonFatals to limit
     *
     * @param ids ids of the non fatals to be deleted
     */
    void trimToLimit(@Nullable List<Long> ids);

    /**
     * Gets list of all cached non-fatals
     *
     * @return list of non-fatal
     */
    @NonNull
    List<NonFatal> getAllNonFatals();

    /**
     * Returns the id of the passed nonFatal in the non_fatal table,
     * or -1 if the db does not contain the element.
     *
     * @param nonFatal the nonFatal object to find in db
     * @return id of the non_fatal or -1
     */
    long getNonFatalId(NonFatal nonFatal);


    /**
     * Delete all saved non-fatals
     */
    void clearAll();

    /**
     * Gets ids of non fatal that will be deleted when non fatals table is trimmed
     * @param nonFatalsMaxCount trimming limit
     * @return ids of non fatals eligible for deletion
     */
    @Nullable
    List<Long> getEligibleToBeDeleted(int nonFatalsMaxCount);

    void deleteNonFatal(long id);
}
