package com.instabug.library.diagnostics.diagnostics_db

import android.content.Context
import android.database.sqlite.SQLiteDatabase
import android.database.sqlite.SQLiteOpenHelper
import android.os.Build
import androidx.annotation.WorkerThread
import com.instabug.library.diagnostics.diagnostics_db.migration.DiagnosticsMigrationEngine

class DiagnosticsDbHelper(context: Context?) :
    SQLiteOpenHelper(context, DATABASE_NAME, null, CURRENT_VERSION) {

    override fun onCreate(db: SQLiteDatabase?) = DiagnosticsMigrationEngine.onCreate(db)

    @WorkerThread
    override fun onUpgrade(db: SQLiteDatabase?, oldVersion: Int, newVersion: Int) =
        DiagnosticsMigrationEngine.onUpgrade(db, oldVersion)

    @WorkerThread
    override fun onDowngrade(db: SQLiteDatabase?, oldVersion: Int, newVersion: Int) {
        DiagnosticsMigrationEngine.onDowngrade(db)
    }

    override fun onConfigure(db: SQLiteDatabase?) {
        super.onConfigure(db)
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
            db?.setForeignKeyConstraintsEnabled(true)
        }
    }

    override fun onOpen(db: SQLiteDatabase) {
        super.onOpen(db)
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.JELLY_BEAN) {
            db.execSQL("PRAGMA foreign_keys=ON;")
        }
    }

    companion object {
        private const val DATABASE_NAME = "ibg_diagnostics.db"
    }
}