package com.instabug.library.diagnostics

fun isAnInternalException(stackTrace: Array<StackTraceElement?>?): Boolean = stackTrace
    ?.takeIf { it.isNotEmpty() }
    ?.asSequence()
    ?.filterNotNull()
    ?.firstOrNull { isValidStackTraceElement(it) } != null

private fun isValidStackTraceElement(element: StackTraceElement) =
    element.className.startsWith("com.instabug")

fun isCalledInternally(stackTrace: Array<StackTraceElement?>?): Boolean = stackTrace
    ?.takeIf { it.isNotEmpty() }
    ?.asSequence()
    ?.filterNotNull()
    ?.dropWhile { !it.className.contains("IBGDiagnostics") }
    ?.drop(1)
    ?.firstOrNull { isValidStackTraceElement(it) } != null
