package com.instabug.library.datahub.networkLog

import com.instabug.library.datahub.DataHubLog
import com.instabug.library.map.Mapper
import com.instabug.library.networkinterception.model.NetworkLogModel
import org.json.JSONObject

class NetworkDataHubLog(
    networkLogModel: NetworkLogModel,
    mapper: Mapper<NetworkLogModel, JSONObject?>
) : DataHubLog {

    private val logJSONObject: JSONObject? by lazy {
        mapper.map(networkLogModel)
    }

    override val dataHubRep: JSONObject?
        get() = logJSONObject
}
