package com.instabug.library.customizations;

import android.graphics.Color;
import android.os.Handler;
import android.os.Looper;

import com.instabug.library.Feature;
import com.instabug.library.IBGFeature;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugCustomTextPlaceHolder;
import com.instabug.library.InstabugFeaturesManager;
import com.instabug.library.internal.module.InstabugLocale;
import com.instabug.library.model.IBGTheme;
import com.instabug.library.settings.SettingsManager;

import java.util.Locale;

public class Customizations {

    //Customizations for ventee privee
    public static void vpCustomizations() {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable() {
            @Override
            public void run() {
                Instabug.setLocale(new Locale(InstabugLocale.FRENCH.getCode(), InstabugLocale.FRENCH
                        .getCountry()));

                InstabugCustomTextPlaceHolder placeHolder = new InstabugCustomTextPlaceHolder();
                placeHolder.set(InstabugCustomTextPlaceHolder.Key.INVALID_COMMENT_MESSAGE, "Hey, écrivez-nous un message pour nous aider.");
                placeHolder.set(InstabugCustomTextPlaceHolder.Key.INVALID_EMAIL_MESSAGE, "Oups ! L’email est invalide !, Retentez votre chance.");
                placeHolder.set(InstabugCustomTextPlaceHolder.Key.REPORT_SUCCESSFULLY_SENT, "C’est dans la boîte !\nGrâce à vous, notre application s’améliore !");
                placeHolder.set(InstabugCustomTextPlaceHolder.Key.INVOCATION_HEADER, "Bonjour ! Que souhaitez-vous faire?");
                placeHolder.set(InstabugCustomTextPlaceHolder.Key.EMAIL_FIELD_HINT, "Saisissez votre adresse e-mail");
                placeHolder.set(InstabugCustomTextPlaceHolder.Key.COMMENT_FIELD_HINT_FOR_BUG_REPORT, "Décrivez le bug rencontré en quelques mots. On met les débuggers sur le coup !");
                placeHolder.set(InstabugCustomTextPlaceHolder.Key.COMMENT_FIELD_HINT_FOR_FEEDBACK, "Décrivez votre super idée en quelques mots. On met les développeurs sur le coup !");

                SettingsManager.getInstance().setCustomPlaceHolders(placeHolder);


                InstabugFeaturesManager.getInstance().setFeatureState(IBGFeature.BUG_REPORTING, Feature.State.ENABLED);
                InstabugFeaturesManager.getInstance().setFeatureState(IBGFeature.REPLIES, Feature.State.DISABLED);


                int color = Color.parseColor("#DB2B6E");
                Instabug.setTheme(new IBGTheme.Builder().setPrimaryColor(color).build());
            }
        });
    }
}
