package com.instabug.library.core.ui;

import android.content.Intent;
import android.os.Bundle;

import androidx.annotation.LayoutRes;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;

import com.instabug.library.R;
import com.instabug.library._InstabugActivity;
import com.instabug.library.broadcast.SDKInvokedBroadcast;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugThemeResolver;
import com.instabug.library.util.LocaleUtils;
import com.instabug.library.util.StatusBarUtils;
import com.instabug.library.util.UiUtils;

public abstract class BaseFragmentActivity<P extends BaseContract.Presenter> extends AppCompatActivity implements _InstabugActivity, BaseContract.View<AppCompatActivity> {

    @Nullable
    protected P presenter;
    private static final String IB_PID = "INSTABUG_PROCESS_ID";

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {

        StatusBarUtils.setStatusBar(this);

        LocaleUtils.setLocale(this, InstabugCore.getLocale(this));

        super.onCreate(savedInstanceState);

        setTheme(InstabugThemeResolver.resolveTheme(SettingsManager.getInstance().getTheme()));

        if (InstabugCore.isFullScreen()) {
            UiUtils.showInFullscreen(this.getWindow());
        }

        setContentView(getLayout());

        initViews();

        getWindow().getDecorView().setId(R.id.instabug_decor_view);

    }

    @Override
    public void onStart() {
        super.onStart();
    }

    @Override
    protected void onResume() {
        super.onResume();
        Intent SDKInvokedStatChanged = new Intent();
        SDKInvokedStatChanged.setAction(SDKInvokedBroadcast.SDK_INVOKED);
        SDKInvokedStatChanged.putExtra(SDKInvokedBroadcast.SDK_INVOKED_STATE, true);
        LocalBroadcastManager.getInstance(this).sendBroadcast(SDKInvokedStatChanged);
    }

    @Override
    protected void onPause() {
        super.onPause();
        Intent SDKInvokedStatChanged = new Intent();
        SDKInvokedStatChanged.setAction(SDKInvokedBroadcast.SDK_INVOKED);
        SDKInvokedStatChanged.putExtra(SDKInvokedBroadcast.SDK_INVOKED_STATE, false);
        LocalBroadcastManager.getInstance(this).sendBroadcast(SDKInvokedStatChanged);
    }

    @Override
    public void onStop() {
        LocaleUtils.setAppLocale(this);
        super.onStop();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
    }

    @Override
    public AppCompatActivity getViewContext() {
        return this;
    }


    @Override
    public void finishActivity() {
        finish();
    }

    /**
     * @return layout resource id.
     */
    protected abstract
    @LayoutRes
    int getLayout();

    /**
     * Init activity views
     */
    protected abstract void initViews();

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt(IB_PID, android.os.Process.myPid());
    }

    @Override
    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        if (savedInstanceState != null) {
            if (savedInstanceState.getInt(IB_PID, -1) != android.os.Process.myPid()) {
                // App-process was killed before, finish Instabug Activities
                finishActivity();
            }
        }
    }
}
