package com.instabug.library.core.eventbus;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;

import com.instabug.library.InstabugState;

public class InstabugStateEventBus extends EventBus<InstabugState> {

    @Nullable
    private static InstabugStateEventBus instabugStateEventBus;

    private InstabugStateEventBus() {
    }

    public static synchronized InstabugStateEventBus getInstance() {
        if (instabugStateEventBus == null) {
            instabugStateEventBus = new InstabugStateEventBus();
        }
        return instabugStateEventBus;
    }

    @VisibleForTesting
    public static synchronized void reset() {
        instabugStateEventBus = null;
    }
}
