package com.instabug.library.core.eventbus;


import com.instabug.library.Constants;
import com.instabug.library.util.InstabugSDKLogger;

import io.reactivexport.Observable;
import io.reactivexport.disposables.Disposable;
import io.reactivexport.functions.Consumer;
import io.reactivexport.subjects.PublishSubject;

/**
 * Created by tarek on 8/30/16.
 */
public class EventBus<T> {

    private final PublishSubject<T> subject;

    protected EventBus() {
        this(PublishSubject.<T>create());
    }

    protected EventBus(PublishSubject<T> subject) {
        this.subject = subject;
    }

    public <E extends T> void post(E event) {
        try {
            subject.onNext(event);
        } catch (Throwable throwable) {
            // fail silently
            InstabugSDKLogger.e(Constants.LOG_TAG, "Error while posting event: " + throwable.getMessage(), throwable);

        }
    }

    public Disposable subscribe(final Consumer<? super T> consumer) {
        return subject.subscribe(consumer, new Consumer<Throwable>() {
            @Override
            public void accept(Throwable throwable) {
                InstabugSDKLogger.e(Constants.LOG_TAG, "Error while receiving event: " + throwable.getMessage(), throwable);
            }
        });
    }

    public Observable<T> getEventObservable() {
        return subject;
    }

    public <E extends T> Observable<E> observeEvents(Class<E> eventClass) {
        return subject.ofType(eventClass);//pass only events of specified type, filter all other
    }

    public boolean hasObservers() {
        return subject.hasObservers();
    }
}