package com.instabug.library.common.composition

/**
 * Apply the condition in the composite and all it's children, and returns immediately once the
 * condition is met
 */
inline fun Composite<*>.any(
    condition: (Any) -> Boolean
): Boolean {
    var currentItem: Any? = this
    while (currentItem != null) {
        if (currentItem.validate(condition)) {
            return true
        } else {
            currentItem = currentItem.nextChild()
        }
    }
    return false
}

inline fun Any?.validate(condition: (Any) -> Boolean) =
    this?.takeIf(condition)
        ?.let { true }
        ?: false

fun Any.nextChild(): Any? = if (this is Composite<*>) this.child() else null
