package com.instabug.library.bugreporting.model;

import androidx.annotation.DrawableRes;
import androidx.annotation.Nullable;

/**
 * The Class ReportCategory to create a new ReportCategory.
 * <p>
 * To create a new ReportCategory you must use {@link #getInstance()} then
 * you should use {@link #withIcon(int)} and {@link #withLabel(String)}
 *
 * @author tarek
 * @since 4.0.2
 */
// TODO remove this after splitting
public class ReportCategory {

    @Nullable
    private String label;
    private int icon;

    private ReportCategory() {

    }

    /**
     * Gets a new instance of ReportCategory model object.
     *
     * @return the instance
     */
    public static ReportCategory getInstance() {
        return new ReportCategory();
    }

    /**
     * sets the reportCategory label
     *
     * @param label the label
     * @return the report category
     */
    public ReportCategory withLabel(@Nullable String label) {
        this.label = label;
        return this;
    }

    /**
     * sets the reportCategory icon.
     *
     * @param icon the icon
     * @return the report category
     */
    public ReportCategory withIcon(@DrawableRes int icon) {
        this.icon = icon;
        return this;
    }

    /**
     * Gets label.
     *
     * @return the label
     */
    @Nullable
    public String getLabel() {
        return label;
    }

    /**
     * Sets label.
     *
     * @param label the label
     */
    public void setLabel(String label) {
        this.label = label;
    }

    /**
     * Gets icon.
     *
     * @return the icon
     */
    public int getIcon() {
        return icon;
    }

    /**
     * Sets icon.
     *
     * @param icon the icon
     */
    public void setIcon(@DrawableRes int icon) {
        this.icon = icon;
    }
}
