package com.instabug.library.visualusersteps.manual

import com.instabug.library.Constants.LOG_TAG
import com.instabug.library.util.CoolDownThrottle
import com.instabug.library.util.InstabugSDKLogger
import com.instabug.library.visualusersteps.ReproStepsManualCaptor
import com.instabug.library.visualusersteps.manual.configuration.ManualUserStepsConfigurationProvider

class ReproStepsManualCaptorProxy(
    private val originalCaptor: ReproStepsManualCaptor,
    private val configuration: ManualUserStepsConfigurationProvider,
    private val throttle: CoolDownThrottle
) : ReproStepsManualCaptor {

    override fun duplicateCurrentParent() {
        originalCaptor.takeIf { configuration.enabled }
            ?.also {
                throttle.invoke(
                    invocation = { it.duplicateCurrentParent() },
                    onCoolDown = { logVerbose(LOG_THROTTLING_RESTRICTION) }
                )
            } ?: logVerbose(LOG_FEATURE_DISABLED)
    }

    private fun logVerbose(message: String) {
        InstabugSDKLogger.d(LOG_TAG, message)
    }
}
