package com.instabug.library.view.viewgroup;

import android.view.View;

import com.instabug.library.util.MathUtils;

class PercentageRelativeLayoutPresenter implements PercentageRelativeLayoutContract.Presenter {

    private final PercentageRelativeLayoutContract.View view;

    PercentageRelativeLayoutPresenter(PercentageRelativeLayoutContract.View view) {
        this.view = view;
    }

    @Override
    public int[] calculateMeasureSpec(int widthMeasureSpec, int heightMeasureSpec) {
        float screenHeight = view.getScreenHeight();
        float maxHeightRatio = view.getMaxHeightRatio();
        float maxHeight = MathUtils.getPercentageOf(screenHeight, (int) maxHeightRatio);
        int measuredHeight = View.MeasureSpec.getSize(heightMeasureSpec);
        if (maxHeight > 0 && maxHeight < measuredHeight) {
            int measureMode = View.MeasureSpec.getMode(heightMeasureSpec);
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int) maxHeight, measureMode);
        }
        return new int[]{widthMeasureSpec, heightMeasureSpec};
    }
}
