package com.instabug.library.util.filters.actions;

/**
 * A functional interface similar to {@link Runnable} that allows passing a consumable element
 *
 * @param <T> type of the consumable element
 */
@FunctionalInterface
public interface Action<T> {

    /**
     * Runs the action and optionally consumes the passed element {@code t}
     *
     * @param t the element to be consumed
     */
    void apply(T t);
}
