package com.instabug.library.util.extenstions

import org.json.JSONObject
import java.io.BufferedReader
import java.io.InputStream
import java.io.OutputStream

private const val DEFAULT_BUFFER_SIZE = 1024

/**
 * writes given input stream to the the output stream receiver
 * @param arraySize is the buffer array size the default is 1024
 * (Note) U need to close the stream after writing
 * */
fun OutputStream.write(
    inputStream: InputStream,
    arraySize: Int = DEFAULT_BUFFER_SIZE
) {
    inputStream.copyTo(this, arraySize)
}

internal inline fun BufferedReader.readJSONLines(action: (JSONObject) -> Unit) {
    use { closable ->
        var line: String?
        while (closable.readLine().also { line = it } != null) {
            line?.let(::JSONObject)?.also(action)
        }
    }
}
