package com.instabug.library.util

import androidx.annotation.WorkerThread
import com.instabug.library.Instabug
import com.instabug.library.diagnostics.diagnostics_db.DiagnosticsDbManager
import com.instabug.library.diagnostics.diagnostics_db.dropDiagnosticsDb
import com.instabug.library.internal.storage.DiskUtils
import com.instabug.library.internal.storage.cache.db.DatabaseManager
import com.instabug.library.internal.storage.cache.dbv2.IBGDbContract
import com.instabug.library.internal.storage.cache.dbv2.IBGDbManager

class SdkDataCleaningUtil {

    /**
     * Delete all of the data collected by the SDK including files and databases.
     * This method doesn't clear or reset the shared-preferences files.
     */
    @WorkerThread
    fun clearSdkData() {
        deleteSdkFiles()
        deleteDatabases()
    }

    /**
     * Delete all files created by the sdk whether it's exists in internal or external storage.
     */
    fun deleteSdkFiles() {
        DiskUtils.deleteSDKDirectory()
        DiskUtils.deleteSdkExternalDirectory()

        DiskUtils.deleteAllStateFiles()
        DiskUtils.deleteNonfatalStateFiles()
    }

    /**
     * Clear up all sdk database tables entries.
     */
    @WorkerThread
    fun clearDatabase() {
        if (Instabug.getApplicationContext() != null) {
            DatabaseManager.clearAll()
            dropDiagnosticsDb()
            IBGDbManager.getInstance().also {
                it.delete(IBGDbContract.BugEntry.TABLE_NAME, null, null)
                it.delete(IBGDbContract.FatalHangEntry.TABLE_NAME, null, null)
                it.delete(IBGDbContract.AppTerminationEntry.TABLE_NAME, null, null)
                it.delete(IBGDbContract.SessionReplayMetadataEntry.TABLE_NAME, null, null)
            }
        }
    }

    /**
     * Delete Instabug data bases.
     */
    @WorkerThread
    fun deleteDatabases() {
        Instabug.getApplicationContext()?.let { context ->
            DatabaseManager.getInstance().deleteDatabase(context)
            IBGDbManager.getInstance().deleteDatabase(context)
            DiagnosticsDbManager.getInstance().deleteDatabase(context)
        }
    }
}