package com.instabug.library.util;

import androidx.annotation.Nullable;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/**
 * Created by Tarek360 on 1/10/17.
 */

public class MD5Generator {

    /**
     * @param data to hash
     * @return a hexadecimal encoded MD5 hash for the input String
     */
    @Nullable
    public static String generateMD5(String data) {
        if (data == null || data.isEmpty()) {
            return "";
        }

        try {
            byte[] bytesOfMessage = data.getBytes("UTF-8");

            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] digest = md.digest(bytesOfMessage);


            StringBuilder hexString = new StringBuilder();

            for (byte b : digest) {
                if ((0xFF & b) < 0x10) {
                    hexString.append("0");
                    hexString.append(Integer.toHexString((0xFF & b)));
                } else {
                    hexString.append(Integer.toHexString(0xFF & b));
                }
            }

            return hexString.toString();

        } catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return null;
    }

}
