package com.instabug.library.util;

import androidx.annotation.StyleRes;

import com.instabug.library.Feature;
import com.instabug.library.IBGFeature;
import com.instabug.library.InstabugColorTheme;
import com.instabug.library.R;
import com.instabug.library.core.InstabugCore;

/**
 * @author mSobhy
 */
public class InstabugThemeResolver {
    @StyleRes
    public static int resolveTheme(InstabugColorTheme instabugTheme) {
        if (!InstabugCore.isFeatureEnabled(IBGFeature.CUSTOM_FONT)) {
            if (instabugTheme == InstabugColorTheme.InstabugColorThemeLight) {
                return R.style.InstabugSdkTheme_Light;
            } else {
                return R.style.InstabugSdkTheme_Dark;
            }
        } else {
            return getCustomFontTheme(instabugTheme);
        }
    }

    @StyleRes
    private static int getCustomFontTheme(InstabugColorTheme instabugTheme) {
        if (instabugTheme == InstabugColorTheme.InstabugColorThemeLight) {
            return R.style.InstabugSdkTheme_Light_CustomFont;
        } else {
            return R.style.InstabugSdkTheme_Dark_CustomFont;
        }
    }
}