package com.instabug.library.util;

import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.widget.ImageView;

import com.instabug.library.core.InstabugCore;
import com.instabug.library.settings.SettingsManager;

/**
 * @author mSobhy
 */
public class Colorizer {

    /**
     * Apply tint to Drawable using the currently set primary color
     *
     * @param drawable to apply tint to
     * @return Tinted drawable
     */
    public static Drawable getPrimaryColorTintedDrawable(Drawable drawable) {
        return getTintedDrawable(InstabugCore.getPrimaryColor(), drawable);
    }

    /**
     * Apply tint to Drawable using the provided tint color
     *
     * @param tintColor to be used for tinting
     * @param drawable  to apply tinting to
     * @return Tinted drawable
     */
    public static Drawable getTintedDrawable(int tintColor, Drawable drawable) {
        drawable.clearColorFilter();
        drawable.setColorFilter(tintColor, PorterDuff.Mode.SRC_IN);
        return drawable;
    }

    /**
     * Apply tint using the currently set primary color
     *
     * @param imageView to apply tinting to
     * @see SettingsManager#getPrimaryColor()
     */
    public static void applyPrimaryColorTint(ImageView imageView) {
        applyTint(SettingsManager.getInstance().getPrimaryColor(), imageView);
    }

    /**
     * Apply tint using the provided tint color
     *
     * @param tintColor to be used for tinting
     * @param imageView to apply tinting to
     */
    public static void applyTint(int tintColor, ImageView imageView) {
        imageView.clearColorFilter();
        imageView.setColorFilter(new PorterDuffColorFilter(tintColor, PorterDuff.Mode.SRC_IN));
    }

    /**
     * Getting new Color filter with the current primary color
     *
     * @return new instance of {@link ColorFilter}
     */
    public static ColorFilter getPrimaryColorFilter() {
        return new PorterDuffColorFilter(SettingsManager.getInstance().getPrimaryColor(),
                PorterDuff.Mode.SRC_IN);
    }
}
