package com.instabug.library.util

import android.accessibilityservice.AccessibilityServiceInfo
import android.annotation.SuppressLint
import android.content.Context
import android.os.Build
import android.view.accessibility.AccessibilityEvent
import android.view.accessibility.AccessibilityManager
import com.instabug.library.Instabug

object AccessibilityUtils {
    private val accessibilityManager
        get() = Instabug.getApplicationContext()
            ?.getSystemService(Context.ACCESSIBILITY_SERVICE) as AccessibilityManager?

    @JvmStatic
    val isTalkbackEnabled: Boolean
        get() =
            accessibilityManager?.getEnabledAccessibilityServiceList(AccessibilityServiceInfo.FEEDBACK_SPOKEN)
                ?.any {
                    it.id.endsWith("TalkBackService")
                } ?: false

    @SuppressLint("InlinedApi")
    @JvmStatic
    fun sendTextEvent(message: String) {
        Build.VERSION.SDK_INT
            .takeIf { version -> version >= Build.VERSION_CODES.JELLY_BEAN && isTalkbackEnabled }
            ?.let { AccessibilityEvent.obtain(AccessibilityEvent.TYPE_ANNOUNCEMENT) }
            ?.apply { text.add(message) }
            ?.let { event -> accessibilityManager?.sendAccessibilityEvent(event) }
    }


}