package com.instabug.library.user.handlepushtoken

import com.instabug.library.Constants
import com.instabug.library.networkv2.RequestResponse
import com.instabug.library.networkv2.request.Endpoints
import com.instabug.library.networkv2.request.Request
import com.instabug.library.networkv2.request.RequestMethod
import com.instabug.library.networkv2.request.RequestParameter
import com.instabug.library.networkv2.request.RequestType
import com.instabug.library.sessionV3.di.IBGSessionServiceLocator
import com.instabug.library.util.InstabugSDKLogger

class PushNotificationRequestHelper {
    companion object{
        private const val PUSH_TOKEN = "push_token"
    }

     private fun updatePushNotificationTokenRequest(pushToken : String) : Request? {
        return Request.Builder().method(RequestMethod.POST)
            .endpoint(Endpoints.PUSH_TOKEN)
            .addParameter(RequestParameter(PUSH_TOKEN,pushToken))
            .build()
    }

    fun handleSendPushTokenRequests(pushToken: String, onSuccess: Runnable?){
        val callback = object : Request.Callbacks<RequestResponse, Throwable>{
            override fun onSucceeded(response: RequestResponse?) {
                InstabugSDKLogger.v(Constants.LOG_TAG,"Push Notification Token Send successfully " + response!!.responseCode)
                onSuccess?.run()
            }

            override fun onFailed(error: Throwable?) {
                InstabugSDKLogger.e(Constants.LOG_TAG,"Push Notification Token failed to send " + error!!.message)
            }

        }
        updatePushNotificationTokenRequest(pushToken)?.let { request ->
            IBGSessionServiceLocator.networkManager.doRequestOnSameThread(RequestType.NORMAL, request, callback)
        }
    }


}