package com.instabug.library.user

import com.instabug.library.Constants
import com.instabug.library.util.InstabugSDKLogger

const val UserIdCharactersLimit = 36
private const val ID_EXCEEDED_LIMIT_ERROR_MESSAGE =
    "User ID Max character counts reached. Please note that you can add User ID with characters count up to 36 characters count Otherwise we will drop."

fun interface Validator {
    operator fun invoke(value: String?): Boolean
}

//TBD
class EmailValidator : Validator {
    override fun invoke(value: String?): Boolean = value
        .takeUnless(::emailIsBlank)
        ?.let(::emailIsValid) ?: false

    private fun emailIsBlank(email: String?) = email.isNullOrBlank()
        .also { isBlank ->
            if (isBlank)
                InstabugSDKLogger.e(Constants.LOG_TAG, "Empty email, Can't identify user")
        }

    private fun emailIsValid(email: String): Boolean {
        val isValid = PatternsProvider.emailPattern?.matcher(email.trim())?.matches() == true
        if (!isValid)
            InstabugSDKLogger.w(
                Constants.LOG_TAG,
                "Invalid email passed to setIdentifiedUserEmail, ignoring."
            )
        return isValid
    }

}

class UserIdValidator(
    private val charactersLimit: Int = UserIdCharactersLimit
) : Validator {
    override fun invoke(value: String?): Boolean {
        return !value.isNullOrBlank() && isNotExceedingCharactersLimit(value)
    }

    private fun isNotExceedingCharactersLimit(value: String): Boolean {
        val charactersLimitExceeded = value.trim().length > charactersLimit
        if (charactersLimitExceeded) {
            InstabugSDKLogger.e(Constants.LOG_TAG, ID_EXCEEDED_LIMIT_ERROR_MESSAGE)
        }
        return !charactersLimitExceeded
    }

}
