package com.instabug.library.sessionreplay

interface SRStateChangeListener {
    fun onSRStateChanged(isEnabled: Boolean)
}

interface SRStateChangeListenersRegistry : SRStateChangeListener {
    fun register(listener: SRStateChangeListener)
}

class BasicSRStateChangeListenersRegistry : SRStateChangeListenersRegistry {
    private val listeners = mutableListOf<SRStateChangeListener>()

    @Synchronized
    override fun register(listener: SRStateChangeListener) {
        listeners.takeUnless { it.contains(listener) }
            ?.run { add(listener) }
    }

    override fun onSRStateChanged(isEnabled: Boolean) {
        listeners.forEach { listener -> listener.onSRStateChanged(isEnabled) }
    }
}