package com.instabug.library.sessionprofiler.model.timeline;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;

/**
 * Created by tarek on 3/4/18.
 */

public class CPUUsage extends TimelinePoint {

    private float value;

    public float getValue() {
        return value;
    }

    public void setValue(float value) {
        this.value = value;
    }

    @Override
    protected JSONObject toJSONObject() throws JSONException {
        return getTimelinePointJSONObject(value);
    }

    private static CPUUsage fromJSONObject(JSONObject jsonObject) throws JSONException {
        CPUUsage cpuUsage = new CPUUsage();
        cpuUsage.setTime(jsonObject.getDouble(KEY_TIME));
        cpuUsage.setValue((float) jsonObject.getDouble(KEY_VALUE));
        return cpuUsage;
    }

    static Collection<TimelinePoint> fromJSONArray(JSONArray jsonArray) throws
            JSONException {
        Collection<TimelinePoint> cpuUsages = new ConcurrentLinkedQueue<>();

        for (int i = 0; i < jsonArray.length(); i++) {
            cpuUsages.add(fromJSONObject(jsonArray.getJSONObject(i)));
        }
        return cpuUsages;
    }
}
