package com.instabug.library.sessionV3.ratingDialogDetection

import android.app.Activity
import android.os.Build
import android.view.View
import android.view.WindowInsets
import androidx.annotation.RequiresApi
import com.instabug.library.util.threading.PoolProvider
import java.lang.ref.WeakReference

@RequiresApi(api = Build.VERSION_CODES.R)
class AppRatingDialogKeyboardEventListener(activity: Activity, callback: KeyboardCallback) {
    private val listener: View.OnApplyWindowInsetsListener
    private val activityRef: WeakReference<Activity>
    private val callback: KeyboardCallback
    private var isKeyboardOpen = false

    init {
        activityRef = WeakReference(activity)
        this.callback = callback
        listener = View.OnApplyWindowInsetsListener { v: View?, insets: WindowInsets ->
            val timestampMicro = System.nanoTime() / 1000
            PoolProvider.postOrderedIOTask(
                "KeyboardListener"
            ) {
                if(insets.isVisible(WindowInsets.Type.ime()) != isKeyboardOpen) {
                    isKeyboardOpen = !isKeyboardOpen
                    dispatchKeyboardEvent(
                        isKeyboardOpen,
                        timestampMicro
                    )
                }
            }
            insets
        }
        registerKeyboardListener()
    }

    private fun registerKeyboardListener() {
        activityRef.get()?.window?.decorView?.setOnApplyWindowInsetsListener(listener)
    }

    private fun dispatchKeyboardEvent(isOpen: Boolean, timeStampMicro: Long) {
        callback.isOpen(isOpen, timeStampMicro)
    }

    fun unregisterKeyboardListener() {
        activityRef.get()?.window?.decorView?.setOnApplyWindowInsetsListener(null)
    }

    interface KeyboardCallback {
        fun isOpen(isKeyboardOpen: Boolean, timeMicros: Long)
    }
}