package com.instabug.library.screenshot.instacapture

import com.instabug.library.util.threading.PoolProvider


/**
 *
 * manges the given screenshot requests
 *
 * */
interface IBGScreenshotCapture {
    fun process(request: ScreenshotRequest)
}

object IBGScreenshotCaptureImpl : IBGScreenshotCapture {
    private const val screenshotOrderKey = "screenshot"
    override fun process(request: ScreenshotRequest) {
        PoolProvider.postOrderedIOTask(screenshotOrderKey) {
            request.start()
        }
    }
}