package com.instabug.library.screenshot.analytics

import com.instabug.library.Constants
import com.instabug.library.core.eventbus.eventpublisher.Subscriber
import com.instabug.library.util.InstabugSDKLogger

class CommonAnalyticsCollector : ScreenshotsAnalyticsHolder, Subscriber<AnalyticsEvent> {

    private var screenshotAnalytics = ScreenshotAnalytics()
    override fun onNewEvent(event: AnalyticsEvent) {
        when (event) {
            is AnalyticsEvent.ErrorEvent -> {
                screenshotAnalytics.onScreenshotCaptureError(event)
            }

            is AnalyticsEvent.ScreenshotEvent.NewScreenshotCaptured -> {
                screenshotAnalytics.onScreenShotSuccessfullyCaptured()
            }


            is AnalyticsEvent.ScreenshotEvent.ScreenshotsTrimmed -> {
                screenshotAnalytics.onScreenShotDropped()

            }

            is AnalyticsEvent.ClearScreenShotAnalyticsData -> {
                screenshotAnalytics = ScreenshotAnalytics()
            }

            else -> {
                InstabugSDKLogger.v(
                    Constants.LOG_TAG,
                    "CommonAnalyticsCollector tracks all relevant events"
                )
            }
        }

    }

    override fun getAnalytics(): ScreenshotAnalytics = screenshotAnalytics.copy()
}