package com.instabug.library.networkv2.request;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

import androidx.annotation.StringDef;

/**
 String def used in define API request method.
 */
@StringDef({RequestMethod.GET, RequestMethod.POST, RequestMethod.PUT, RequestMethod.DELETE})
@Retention(RetentionPolicy.SOURCE)
public @interface RequestMethod {
    /**
     GET API request method.
     */
    String GET = "GET";

    /**
     POST API request method.
     */
    String POST = "POST";

    /**
     PUT API request method.
     */
    String PUT = "PUT";

    /**
     DELETE API request method.
     */
    String DELETE = "DELETE";
}
