package com.instabug.library.networkv2

import org.json.JSONException
import org.json.JSONObject

open class RequestException(val requestCode: Int, message: String = "") : Exception(message) {
    override fun toString(): String = "RequestException(requestCode = $requestCode${
        if (message.isNullOrEmpty()) ""
        else ", message= $message"
    }) "
}

data class RateLimitedException(val period: Int) :
    RequestException(429) {

    companion object {
        @JvmStatic
        @Throws(JSONException::class)
        fun fromResponse(response: String?): RateLimitedException = response
            .takeUnless { response == null }
            ?.let(::JSONObject)
            ?.optInt("period", 0)
            .let { RateLimitedException(it ?: 0) }


    const val RATE_LIMIT_REACHED: String =
        """You've reached the maximum number of requests in %s. You can read more about our rate limiting policy at this link: https://docs.instabug.com/docs/rate-limits"""
    }
}