package com.instabug.library.networkDiagnostics.caching

import android.content.Context
import android.content.SharedPreferences
import androidx.annotation.WorkerThread
import com.instabug.library.networkDiagnostics.NetworkDiagnosticsConstants.NETWORK_DIAGNOSTICS_PREFERENCES_KEY
import com.instabug.library.networkDiagnostics.model.NetworkDiagnostics
import com.instabug.library.networkDiagnostics.model.NetworkDiagnosticsWrapper
import com.instabug.library.networkDiagnostics.model.toJson
import com.instabug.library.networkDiagnostics.model.toNetworkDiagnosticsWrapper
import com.instabug.library.settings.SettingsManager

interface NetworkDiagnosticsCachingManager {
    fun dumpToDisk(networkDiagnosticsWrapper: NetworkDiagnosticsWrapper)

    fun loadFromDisk(): NetworkDiagnosticsWrapper

    fun clearCachedDate()
}

class NetworkDiagnosticsCachingManagerImpl(
    private val ctxGetter: () -> Context?,
) : NetworkDiagnosticsCachingManager {

    private var sharedPreferences: SharedPreferences? = null
    private var editor: SharedPreferences.Editor? = null

    init {
        sharedPreferences = ctxGetter.invoke()
            ?.getSharedPreferences(SettingsManager.INSTABUG_SHARED_PREF_NAME, Context.MODE_PRIVATE)
        editor= sharedPreferences?.edit()
    }
    @WorkerThread
    override fun dumpToDisk(
        networkDiagnosticsWrapper: NetworkDiagnosticsWrapper,
    ) {
        editor?.putString(
            NETWORK_DIAGNOSTICS_PREFERENCES_KEY,
            networkDiagnosticsWrapper.toJson()
        )?.commit()
    }

    @WorkerThread
    override fun loadFromDisk(): NetworkDiagnosticsWrapper {
        return sharedPreferences?.getString(NETWORK_DIAGNOSTICS_PREFERENCES_KEY, "")
            ?.toNetworkDiagnosticsWrapper() ?: NetworkDiagnosticsWrapper(
            NetworkDiagnostics(),
            NetworkDiagnostics()
        )
    }

    override fun clearCachedDate() {
        editor?.remove(NETWORK_DIAGNOSTICS_PREFERENCES_KEY)?.commit()
    }

}