package com.instabug.library.model.v3Session

import com.instabug.library.model.common.Extractable
import com.instabug.library.sessionV3.providers.SessionUserDataProvider

data class SessionUserData(
    val uuid: String,
    val userName: String?,
    val userEmail: String?,
    val customAttributes: String?,
    val usersPageEnabled: Boolean,
    val userEvents: String?
) : Extractable {
    companion object Factory {
        fun create(userDataProvider: SessionUserDataProvider): SessionUserData =
            with(userDataProvider) {
                SessionUserData(
                    uuid = uuid,
                    userName = userName,
                    userEmail = userEmail,
                    usersPageEnabled = usersPageEnabled,
                    userEvents = userEvents.asStringJsonArray,
                    customAttributes = userAttributes.asStringJson
                )
            }
    }

    override fun extractFields(map: MutableMap<String, Any>): MutableMap<String, Any> =
        map.apply {
            put(UserDataKeys.UUID_KEY, uuid)
            userEmail
                ?.takeUnless { userEmail.isEmpty() }
                ?.let { put(UserDataKeys.USER_EMAIL_KEY, userEmail) }
            userName
                ?.takeUnless { userName.isEmpty() }
                ?.let { put(UserDataKeys.USER_NAME_KEY, userName) }
            userEvents
                ?.takeUnless(::isEmptyJson)
                ?.let { putUserEvents() }
            customAttributes
                ?.takeUnless(::isEmptyJson)
                ?.let { putCustomAttributes() }

        }

    private fun isEmptyJson(json: String) = json == "[]" || json == "{}"

    private fun MutableMap<String, Any>.putCustomAttributes() {
        put(
            UserDataKeys.CUSTOM_ATTRIBUTES_KEY,
            customAttributes!!
        )
    }

    private fun MutableMap<String, Any>.putUserEvents() = put(
        UserDataKeys.USER_EVENTS_KEY,
        userEvents!!
    )
}